# ############
import math
import arcpy
# from decimal import Decimal
import os


def ele(dpath, jcdpath, dhlayer, tclayer, opath, dgj, dx, str1):
    jd = 0
    if str1 == 'SamePrecision':
        jd = 1
    else:
        jd = -1
    dgjz = float(dgj)
    yz1 = 0
    yz2 = 0
    if dx == 'Flat h/3,h/4':
        yz1 = dgjz / 3
        yz2 = dgjz / 4
    elif dx == 'Hill h/2,h/4':
        yz1 = dgjz / 2
        yz2 = dgjz / 4
    elif dx == 'Mountain 2h/3,h/3':
        yz1 = dgjz * 2 / 3
        yz2 = dgjz / 3
    else:
        yz1 = dgjz
        yz2 = dgjz / 3
    # 先创建两个文件，一个是找得到值得，一个找不到值
    txtpath1 = opath + u'\\一倍限差.txt'
    txtpath2 = opath + u'\\二倍限差.txt'
    txtpath3 = opath + u'\\错误点.txt'
    ppath = dpath + '\\Point'
    lpath = dpath + '\\Polyline'
    path = os.path.dirname(dpath)
    TIN = path + '\\tin'
    arcpy.management.MakeFeatureLayer(ppath, 'POINT')
    arcpy.management.MakeFeatureLayer(lpath, 'LINE')
    arcpy.management.MakeFeatureLayer(jcdpath, 'JCD')
    creattin(dpath, ppath, lpath, TIN)
    # 总值用于计算
    zcz1 = 0
    zcz2 = 0
    ds1 = 0
    ds2 = 0
    with open(txtpath1, 'w') as filea:
        filea.write('检查点名')
        filea.write('\t')
        filea.write('检查点坐标')
        filea.write('\t\t')
        filea.write('检查点高程')
        filea.write('\t')
        filea.write('估算值')
        filea.write('\t')
        filea.write('差值')
        filea.write('\n')
        filea.flush()
        with open(txtpath2, 'w') as fileb:
            fileb.write('检查点名')
            fileb.write('\t')
            fileb.write('检查点坐标')
            fileb.write('\t\t')
            fileb.write('检查点高程')
            fileb.write('\t')
            fileb.write('估算值')
            fileb.write('\t')
            fileb.write('差值')
            fileb.write('\n')
            fileb.flush()
            with open(txtpath3, 'w') as filec:
                filec.write('异常检查点如下：')
                filec.write('\n')
                filec.write('检查点名')
                filec.write('\t')
                filec.write('检查点坐标')
                filec.write('\t\t')
                filec.write('检查点高程')
                filec.write('\n')
                filec.flush()
                ptlist = []
                with arcpy.da.SearchCursor('JCD', ['SHAPE@', dhlayer, tclayer]) as cursorA:
                    for curA in cursorA:
                        jp = curA[0]
                        jpt = jp.firstPoint
                        jpx = jpt.X
                        jpy = jpt.Y
                        pt=[]
                        pt.append(str(curA[1]).split(".")[0])
                        pt.append(jpx)
                        pt.append(jpy)
                        pt.append(curA[2])
                        ptlist.append(pt)
                pt_on_tin = path + "\\ptontin.shp"
                # temp_pt = path + "\\temp_pt.shp"
                # createfc(jp, 'temp_pt', dpath)
                arcpy.InterpolateShape_3d(TIN, jcdpath, pt_on_tin)
                with arcpy.da.UpdateCursor(pt_on_tin, ['SHAPE@', dhlayer, tclayer]) as cursorX:
                    for curX in cursorX:
                        for pt in ptlist:
                            if pt[0] == str(curX[1]).split(".")[0]:
                                ptlist.remove(pt)
                        jp = curX[0]
                        jpt = jp.firstPoint
                        jpx = jpt.X
                        jpy = jpt.Y
                        dh = str(curX[1]).split(".")[0]
                        ele = curX[2]
                        ele1 = curX[0].firstPoint.Z
                        if ele1 != None:
                            if math.fabs(ele - ele1) <= yz2:
                                ds1 = ds1 + 1
                                hc1 = ele - ele1
                                hc2 = hc1 * hc1
                                zcz1 = zcz1 + hc2
                                filea.write(dh)
                                filea.write('\t')
                                filea.write(str(round(jpx, 3)))
                                filea.write(',')
                                filea.write(str(round(jpy, 3)))
                                filea.write('\t')
                                filea.write(str(round(ele, 2)))
                                filea.write('\t\t')
                                filea.write(str(round(ele1, 2)))
                                filea.write('\t')
                                filea.write(str(round(hc1, 2)))
                                filea.write('\n')
                                filea.flush()
                                # arcpy.AddMessage('WRITE OVER - %s' % datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S"))
                                arcpy.AddMessage('WRITE OVER ')
                            elif math.fabs(ele - ele1) > yz2 and math.fabs(ele - ele1) <= yz1:
                                ds2 = ds2 + 1
                                hc1 = ele - ele1
                                hc2 = hc1 * hc1
                                zcz2 = zcz2 + hc2
                                fileb.write(dh)
                                fileb.write('\t')
                                fileb.write(str(round(jpx, 3)))
                                fileb.write(',')
                                fileb.write(str(round(jpy, 3)))
                                fileb.write('\t')
                                fileb.write(str(round(ele, 2)))
                                fileb.write('\t\t')
                                fileb.write(str(round(ele1, 2)))
                                fileb.write('\t')
                                fileb.write(str(round(hc1, 2)))
                                fileb.write('\n')
                                fileb.flush()
                                arcpy.AddMessage('WRITE OVER ')
                            else:
                                hc1 = ele - ele1
                                filec.write(dh)
                                filec.write('\t')
                                filec.write(str(round(jpx, 3)))
                                filec.write(',')
                                filec.write(str(round(jpy, 3)))
                                filec.write('\t')
                                filec.write(str(round(ele, 2)))
                                filec.write('\t\t')
                                filec.write(str(round(ele1, 2)))
                                filec.write('\t')
                                filec.write(str(round(hc1, 2)))
                                filec.write('\n')
                                filec.flush()
                                arcpy.AddMessage('ERROR DATA ')
                        else:
                            filec.write(dh)
                            filec.write('\t')
                            filec.write(str(round(jpx, 3)))
                            filec.write(',')
                            filec.write(str(round(jpy, 3)))
                            filec.write('\t')
                            filec.write(str(round(ele, 2)))
                            filec.write('\t\t')
                            filec.write(str(round(ele1, 2)))
                            filec.write('\t')
                            filec.write('\n')
                            filec.flush()
                            arcpy.AddMessage('NO DATA ')
                    if ptlist.__len__()>0:
                        for pt in ptlist:
                            filec.write(pt[0])
                            filec.write('\t')
                            filec.write(str(round(pt[1], 3)))
                            filec.write(',')
                            filec.write(str(round(pt[2], 3)))
                            filec.write('\t')
                            filec.write(str(round(pt[3], 2)))
                            filec.write('\t\t')
                            filec.write("No Data")
                            filec.write('\t')
                            filec.write('\n')
                            filec.flush()
                            arcpy.AddMessage('NO DATA ')
                # 计算
                    if ds1>0:
                        if jd == -1:
                            zwc11 = zcz1 / ds1
                        else:
                            ds11 = 2 * ds1
                            zwc11 = zcz1 / ds11
                        filea.write('共有 ')
                        filea.write(str(ds1))
                        filea.write(' 个点通过判定')
                        filea.write('\n')
                        filea.write('高程中误差值：')
                        filea.write(str(zwc11))
                        filea.write('\n\n')
                        filea.flush()
                        arcpy.AddMessage('Pointtxt over')
                        arcpy.management.Delete(pt_on_tin)
                    if ds2>0:
                        if jd == -1:
                            zwc22 = zcz2 / ds2
                        else:
                            ds22 = 2 * ds2
                            zwc22 = zcz2 / ds22
                        fileb.write('共有 ')
                        fileb.write(str(ds2))
                        fileb.write(' 个点通过判定')
                        fileb.write('\n')
                        fileb.write('高程中误差值：')
                        fileb.write(str(zwc22))
                        fileb.write('\n\n')
                        fileb.flush()
                        arcpy.AddMessage('Pointtxt over')
                    arcpy.management.Delete(pt_on_tin)
                    arcpy.management.Delete(TIN)


def creattin(dpath, ppath, lpath, TIN):
    # gcd = dpath + '\\gcd'
    # dgx = dpath + '\\dgx'
    field_name = "Layer"
    gcdvalues = ["'8300'", "'GCD'"]
    dgxvalues = ["'8110'", "'8120'", "'DGX'", "'DGX1'", ]
    where_clause_gcd = "{} IN ({})".format(field_name, ', '.join(gcdvalues))
    where_clause_dgx = "{} IN ({})".format(field_name, ', '.join(dgxvalues))
    arcpy.management.MakeFeatureLayer(ppath, 'pt')
    arcpy.management.MakeFeatureLayer(lpath, 'pll')
    arcpy.management.SelectLayerByAttribute('pt', "NEW_SELECTION", where_clause_gcd)
    # arcpy.CopyFeatures_management('pt', gcd)
    arcpy.management.SelectLayerByAttribute('pll', "NEW_SELECTION", where_clause_dgx)
    # arcpy.CopyFeatures_management('pll', dgx)

    sr = arcpy.Describe('pll').spatialReference
    arcpy.ddd.CreateTin(TIN, sr, [['pt', "Elevation", "Mass_Points"], ['pll', "Elevation", "Hard_Line"]])
    arcpy.management.Delete('pll')
    arcpy.management.Delete('pt')


# def createfc(jp, name, dpath):
#     path = os.path.dirname(dpath)
#     arcpy.CreateFeatureclass_management(path, name, "POINT")
#     cursor = arcpy.da.InsertCursor(path + "\\" + name + ".shp", ["SHAPE@"])
#     cursor.insertRow([jp])
#     del cursor


if __name__ == '__main__':
    try:
        # ele(r'D:\6work_now\20260203\test\5000z.dwg', r'D:\6work_now\20260203\test\jcd.shp', 'FID', 'z',
        #     r'D:\6work_now\20260203\out', '5', 'Flat h/3,h/4', 'SamePrecision')
        ele(arcpy.GetParameterAsText(0), arcpy.GetParameterAsText(1), arcpy.GetParameterAsText(2),
            arcpy.GetParameterAsText(3), arcpy.GetParameterAsText(4), arcpy.GetParameterAsText(5),
            arcpy.GetParameterAsText(6), arcpy.GetParameterAsText(7))
    except arcpy.ExecuteError:
        arcpy.AddMessage(arcpy.GetMessages().encode('utf-8'))


